/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessControlException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.python.Version;
import org.python.core.ClassDictInit;
import org.python.core.ClasspathPyImporter;
import org.python.core.JavaImporter;
import org.python.core.JythonInitializer;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyAttributeDeleted;
import org.python.core.PyBoolean;
import org.python.core.PyDictionary;
import org.python.core.PyEllipsis;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFrame;
import org.python.core.PyFrozenSet;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyMethod;
import org.python.core.PyModule;
import org.python.core.PyNone;
import org.python.core.PyNotImplemented;
import org.python.core.PyObject;
import org.python.core.PyReflectedFunction;
import org.python.core.PySingleton;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySyntaxError;
import org.python.core.PySystemStateFunctions;
import org.python.core.PyTraceback;
import org.python.core.PyTuple;
import org.python.core.PythonTraceFunction;
import org.python.core.Shadow;
import org.python.core.StderrWrapper;
import org.python.core.StdoutWrapper;
import org.python.core.ThreadState;
import org.python.core.__builtin__;
import org.python.core.adapter.ClassicPyObjectAdapter;
import org.python.core.adapter.ExtensiblePyObjectAdapter;
import org.python.core.codecs;
import org.python.core.packagecache.PackageManager;
import org.python.core.packagecache.SysPackageManager;
import org.python.modules.Setup;
import org.python.modules.zipimport.zipimporter;
import org.python.posix.util.Platform;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PySystemState
extends PyObject
implements ClassDictInit {
    public static final String PYTHON_CACHEDIR = "python.cachedir";
    public static final String PYTHON_CACHEDIR_SKIP = "python.cachedir.skip";
    public static final String PYTHON_CONSOLE_ENCODING = "python.console.encoding";
    protected static final String CACHEDIR_DEFAULT_NAME = "cachedir";
    public static final String JYTHON_JAR = "jython.jar";
    public static final String JYTHON_DEV_JAR = "jython-dev.jar";
    private static final String JAR_URL_PREFIX = "jar:file:";
    private static final String JAR_SEPARATOR = "!";
    private static final String VFSZIP_PREFIX = "vfszip:";
    public static final PyString version = new PyString(Version.getVersion());
    public static final int hexversion = Version.PY_MAJOR_VERSION << 24 | Version.PY_MINOR_VERSION << 16 | Version.PY_MICRO_VERSION << 8 | Version.PY_RELEASE_LEVEL << 4 | Version.PY_RELEASE_SERIAL << 0;
    public static PyTuple version_info;
    public static final int maxunicode = 0x10FFFF;
    public static PyTuple subversion;
    public static final PyObject copyright;
    private static Map<String, String> builtinNames;
    public static PyTuple builtin_module_names;
    public static PackageManager packageManager;
    private static File cachedir;
    private static PyList defaultPath;
    private static PyList defaultArgv;
    private static PyObject defaultExecutable;
    public static Properties registry;
    public static PyObject prefix;
    public static PyObject exec_prefix;
    public static final PyString byteorder;
    public static final int maxint = Integer.MAX_VALUE;
    public static final int minint = Integer.MIN_VALUE;
    private static boolean initialized;
    public PyList argv = new PyList();
    public PyObject modules;
    public PyList path;
    public static PyList warnoptions;
    public static PyObject builtins;
    public static PyObject platform;
    public PyList meta_path;
    public PyList path_hooks;
    public PyObject path_importer_cache;
    public PyObject ps1 = new PyString(">>> ");
    public PyObject ps2 = new PyString("... ");
    public PyObject executable;
    private String currentWorkingDir;
    private ClassLoader classLoader = null;
    public PyObject stdout;
    public PyObject stderr;
    public PyObject stdin;
    public PyObject __stdout__;
    public PyObject __stderr__;
    public PyObject __stdin__;
    public PyObject __displayhook__;
    public PyObject __excepthook__;
    public PyObject last_value = Py.None;
    public PyObject last_type = Py.None;
    public PyObject last_traceback = Py.None;
    public PyObject __name__ = new PyString("sys");
    public PyObject __dict__;
    private int recursionlimit = 1000;
    public boolean _systemRestart = false;
    private final PySystemStateCloser closer;
    private static final ReferenceQueue<PySystemState> systemStateQueue;
    private static final ConcurrentMap<WeakReference<PySystemState>, PySystemStateCloser> sysClosers;
    private Shadow shadowing;
    private static final String INITIALIZER_SERVICE = "META-INF/services/org.python.core.JythonInitializer";

    public PySystemState() {
        PySystemState.initialize();
        this.closer = new PySystemStateCloser(this);
        this.modules = new PyStringMap();
        this.argv = (PyList)defaultArgv.repeat(1);
        this.path = (PyList)defaultPath.repeat(1);
        this.path.append(Py.newString("__classpath__"));
        this.path.append(Py.newString("__pyclasspath__/"));
        this.executable = defaultExecutable;
        this.meta_path = new PyList();
        this.path_hooks = new PyList();
        this.path_hooks.append(new JavaImporter());
        this.path_hooks.append(zipimporter.TYPE);
        this.path_hooks.append(ClasspathPyImporter.TYPE);
        this.path_importer_cache = new PyDictionary();
        this.currentWorkingDir = new File("").getAbsolutePath();
        String string = Options.unbuffered ? "b" : "";
        int n = Options.unbuffered ? 0 : 1;
        this.stdin = this.__stdin__ = new PyFile(System.in, "<stdin>", "r" + string, n, false);
        this.stdout = this.__stdout__ = new PyFile(System.out, "<stdout>", "w" + string, n, false);
        this.stderr = this.__stderr__ = new PyFile(System.err, "<stderr>", "w" + string, 0, false);
        this.initEncoding();
        this.__displayhook__ = new PySystemStateFunctions("displayhook", 10, 1, 1);
        this.__excepthook__ = new PySystemStateFunctions("excepthook", 30, 3, 3);
        if (builtins == null) {
            builtins = PySystemState.getDefaultBuiltins();
        }
        this.modules.__setitem__("__builtin__", (PyObject)new PyModule("__builtin__", PySystemState.getDefaultBuiltins()));
        this.__dict__ = new PyStringMap();
        this.__dict__.invoke("update", this.getType().fastGetDict());
        this.__dict__.__setitem__("displayhook", this.__displayhook__);
        this.__dict__.__setitem__("excepthook", this.__excepthook__);
    }

    public static void classDictInit(PyObject pyObject) {
        pyObject.__setitem__("trace", null);
        pyObject.__setitem__("profile", null);
    }

    void reload() throws PyIgnoreMethodTag {
        this.__dict__.invoke("update", this.getType().fastGetDict());
    }

    private static void checkReadOnly(String string) {
        if (string == "__dict__" || string == "__class__" || string == "registry" || string == "exec_prefix" || string == "packageManager") {
            throw Py.TypeError("readonly attribute");
        }
    }

    private static void checkMustExist(String string) {
        if (string == "__dict__" || string == "__class__" || string == "registry" || string == "exec_prefix" || string == "platform" || string == "packageManager" || string == "builtins" || string == "warnoptions") {
            throw Py.TypeError("readonly attribute");
        }
    }

    private void initEncoding() {
        String string = registry.getProperty(PYTHON_CONSOLE_ENCODING);
        if (string == null) {
            return;
        }
        for (PyFile pyFile : new PyFile[]{(PyFile)this.stdin, (PyFile)this.stdout, (PyFile)this.stderr}) {
            if (!pyFile.isatty()) continue;
            pyFile.encoding = string;
        }
    }

    public synchronized void shadow() {
        if (this.shadowing == null) {
            this.shadowing = new Shadow();
        }
    }

    public static PyObject getDefaultBuiltins() {
        return DefaultBuiltinsHolder.builtins;
    }

    public synchronized PyObject getBuiltins() {
        if (this.shadowing == null) {
            return PySystemState.getDefaultBuiltins();
        }
        return this.shadowing.builtins;
    }

    public synchronized void setBuiltins(PyObject pyObject) {
        if (this.shadowing == null) {
            builtins = pyObject;
        } else {
            this.shadowing.builtins = pyObject;
        }
        this.modules.__setitem__("__builtin__", (PyObject)new PyModule("__builtin__", pyObject));
    }

    public synchronized PyObject getWarnoptions() {
        if (this.shadowing == null) {
            return warnoptions;
        }
        return this.shadowing.warnoptions;
    }

    public synchronized void setWarnoptions(PyObject pyObject) {
        if (this.shadowing == null) {
            warnoptions = new PyList(pyObject);
        } else {
            this.shadowing.warnoptions = new PyList(pyObject);
        }
    }

    public synchronized PyObject getPlatform() {
        if (this.shadowing == null) {
            return platform;
        }
        return this.shadowing.platform;
    }

    public synchronized void setPlatform(PyObject pyObject) {
        if (this.shadowing == null) {
            platform = pyObject;
        } else {
            this.shadowing.platform = pyObject;
        }
    }

    @Override
    public PyObject __findattr_ex__(String string) {
        if (string == "exc_value") {
            PyException pyException = Py.getThreadState().exception;
            if (pyException == null) {
                return null;
            }
            return pyException.value;
        }
        if (string == "exc_type") {
            PyException pyException = Py.getThreadState().exception;
            if (pyException == null) {
                return null;
            }
            return pyException.type;
        }
        if (string == "exc_traceback") {
            PyException pyException = Py.getThreadState().exception;
            if (pyException == null) {
                return null;
            }
            return pyException.traceback;
        }
        if (string == "warnoptions") {
            return this.getWarnoptions();
        }
        if (string == "builtins") {
            return this.getBuiltins();
        }
        if (string == "platform") {
            return this.getPlatform();
        }
        PyObject pyObject = super.__findattr_ex__(string);
        if (pyObject != null) {
            if (pyObject instanceof PyMethod) {
                if (this.__dict__.__finditem__(string) instanceof PyReflectedFunction) {
                    return pyObject;
                }
            } else {
                if (pyObject == PyAttributeDeleted.INSTANCE) {
                    return null;
                }
                return pyObject;
            }
        }
        return this.__dict__.__finditem__(string);
    }

    @Override
    public void __setattr__(String string, PyObject pyObject) {
        PySystemState.checkReadOnly(string);
        if (string == "builtins") {
            this.shadow();
            this.setBuiltins(pyObject);
        } else if (string == "warnoptions") {
            this.shadow();
            this.setWarnoptions(pyObject);
        } else if (string == "platform") {
            this.shadow();
            this.setPlatform(pyObject);
        } else {
            PyObject pyObject2 = this.getType().lookup(string);
            if (pyObject2 != null && pyObject2._doset(this, pyObject)) {
                return;
            }
            this.__dict__.__setitem__(string, pyObject);
        }
    }

    @Override
    public void __delattr__(String string) {
        block3: {
            PySystemState.checkMustExist(string);
            PyObject pyObject = this.getType().lookup(string);
            if (pyObject != null) {
                pyObject._doset(this, PyAttributeDeleted.INSTANCE);
            }
            try {
                this.__dict__.__delitem__(string);
            }
            catch (PyException pyException) {
                if (pyObject != null) break block3;
                throw Py.AttributeError(string);
            }
        }
    }

    @Override
    public void __rawdir__(PyDictionary pyDictionary) {
        pyDictionary.update(this.__dict__);
    }

    @Override
    public String toString() {
        return "<module '" + this.__name__ + "' (built-in)>";
    }

    public int getrecursionlimit() {
        return this.recursionlimit;
    }

    public void setrecursionlimit(int n) {
        if (n <= 0) {
            throw Py.ValueError("Recursion limit must be positive");
        }
        this.recursionlimit = n;
    }

    public void settrace(PyObject pyObject) {
        ThreadState threadState = Py.getThreadState();
        threadState.tracefunc = pyObject == Py.None ? null : new PythonTraceFunction(pyObject);
    }

    public void setprofile(PyObject pyObject) {
        ThreadState threadState = Py.getThreadState();
        threadState.profilefunc = pyObject == Py.None ? null : new PythonTraceFunction(pyObject);
    }

    public PyString getdefaultencoding() {
        return new PyString(codecs.getDefaultEncoding());
    }

    public void setdefaultencoding(String string) {
        codecs.setDefaultEncoding(string);
    }

    public PyObject getfilesystemencoding() {
        return Py.None;
    }

    public void setCurrentWorkingDir(String string) {
        this.currentWorkingDir = string;
    }

    public String getCurrentWorkingDir() {
        return this.currentWorkingDir;
    }

    public String getPath(String string) {
        return PySystemState.getPath(this, string);
    }

    public static String getPathLazy(String string) {
        return PySystemState.getPath(null, string);
    }

    private static String getPath(PySystemState pySystemState, String string) {
        if (string == null) {
            return string;
        }
        File file = new File(string);
        if (!(file.isAbsolute() || Platform.IS_WINDOWS && (string.startsWith("\\") || string.startsWith("/")))) {
            if (pySystemState == null) {
                pySystemState = Py.getSystemState();
            }
            file = new File(pySystemState.getCurrentWorkingDir(), string);
        }
        return file.getPath();
    }

    public void callExitFunc() throws PyIgnoreMethodTag {
        PyObject pyObject = this.__findattr__("exitfunc");
        if (pyObject != null) {
            try {
                pyObject.__call__();
            }
            catch (PyException pyException) {
                if (!pyException.match(Py.SystemExit)) {
                    Py.println(this.stderr, Py.newString("Error in sys.exitfunc:"));
                }
                Py.printException(pyException);
            }
        }
        Py.flushLine();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private static String findRoot(Properties properties, Properties properties2, String string) {
        Object object;
        String string2 = null;
        try {
            if (properties2 != null) {
                string2 = properties2.getProperty("python.home");
            }
            if (string2 == null) {
                string2 = properties.getProperty("python.home");
            }
            if (string2 == null) {
                string2 = properties.getProperty("install.root");
            }
            PySystemState.determinePlatform(properties);
        }
        catch (Exception exception) {
            return null;
        }
        if (string2 == null && (object = properties.getProperty("java.class.path")) != null) {
            String string3 = ((String)object).toLowerCase();
            int n = string3.indexOf(JYTHON_JAR);
            if (n < 0) {
                n = string3.indexOf(JYTHON_DEV_JAR);
            }
            if (n >= 0) {
                int n2 = ((String)object).lastIndexOf(File.pathSeparator, n) + 1;
                string2 = ((String)object).substring(n2, n);
            } else if (string != null) {
                string2 = new File(string).getParent();
            }
        }
        if (string2 == null) {
            return null;
        }
        object = new File(string2);
        try {
            return ((File)object).getCanonicalPath();
        }
        catch (IOException iOException) {
            return ((File)object).getAbsolutePath();
        }
    }

    public static void determinePlatform(Properties properties) {
        String string;
        String string2 = properties.getProperty("java.version");
        if (string2 == null) {
            string2 = "???";
        }
        if ((string = string2.toLowerCase()).startsWith("java")) {
            string2 = string2.substring(4, string2.length());
        }
        if (string.startsWith("jdk") || string.startsWith("jre")) {
            string2 = string2.substring(3, string2.length());
        }
        if (string2.equals("12")) {
            string2 = "1.2";
        }
        platform = new PyString("java" + string2);
    }

    private static void initRegistry(Properties properties, Properties properties2, boolean bl, String string) {
        Object object;
        String string2;
        if (registry != null) {
            Py.writeError("systemState", "trying to reinitialize registry");
            return;
        }
        registry = properties;
        String string3 = string2 = PySystemState.findRoot(properties, properties2, string);
        if (string2 != null) {
            if (string2.length() == 0) {
                string3 = ".";
                string2 = ".";
            }
            try {
                object = new File(registry.getProperty("user.home"), ".jython");
                PySystemState.addRegistryFile((File)object);
                PySystemState.addRegistryFile(new File(string2, "registry"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string2 != null) {
            prefix = Py.newString(string2);
        }
        if (string3 != null) {
            exec_prefix = Py.newString(string3);
        }
        try {
            object = System.getenv("JYTHONPATH");
            if (object != null) {
                registry.setProperty("python.path", (String)object);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        registry.putAll((Map<?, ?>)properties2);
        if (bl && !registry.containsKey(PYTHON_CACHEDIR_SKIP)) {
            registry.put(PYTHON_CACHEDIR_SKIP, "true");
        }
        if (!registry.containsKey(PYTHON_CONSOLE_ENCODING) && (object = PySystemState.getPlatformEncoding()) != null) {
            registry.put(PYTHON_CONSOLE_ENCODING, object);
        }
        Options.setFromRegistry();
    }

    private static String getPlatformEncoding() {
        String string = PySystemState.getConsoleEncoding();
        if (string == null) {
            try {
                string = System.getProperty("file.encoding");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return string;
    }

    private static String getConsoleEncoding() {
        String string = null;
        try {
            Class<?> clazz = Class.forName("java.io.Console");
            Method method = clazz.getDeclaredMethod("encoding", new Class[0]);
            method.setAccessible(true);
            string = (String)method.invoke(clazz, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addRegistryFile(File file) {
        if (file.exists()) {
            if (!file.isDirectory()) {
                Properties properties = new Properties();
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        properties.load(fileInputStream);
                        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                            Object object = entry.getKey();
                            if (registry.containsKey(object)) continue;
                            registry.put(object, entry.getValue());
                        }
                    }
                    finally {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    System.err.println("couldn't open registry file: " + file.toString());
                }
            } else {
                System.err.println("warning: " + file.toString() + " is a directory, not a file");
            }
        }
    }

    public static Properties getBaseProperties() {
        try {
            return System.getProperties();
        }
        catch (AccessControlException accessControlException) {
            return new Properties();
        }
    }

    public static synchronized void initialize() {
        PySystemState.initialize(null, null);
    }

    public static synchronized void initialize(Properties properties, Properties properties2) {
        PySystemState.initialize(properties, properties2, new String[]{""});
    }

    public static synchronized void initialize(Properties properties, Properties properties2, String[] stringArray) {
        PySystemState.initialize(properties, properties2, stringArray, null);
    }

    public static synchronized void initialize(Properties properties, Properties properties2, String[] stringArray, ClassLoader classLoader) {
        PySystemState.initialize(properties, properties2, stringArray, classLoader, new ClassicPyObjectAdapter());
    }

    public static synchronized void initialize(Properties properties, Properties properties2, String[] stringArray, ClassLoader classLoader, ExtensiblePyObjectAdapter extensiblePyObjectAdapter) {
        if (initialized) {
            return;
        }
        if (properties == null) {
            properties = PySystemState.getBaseProperties();
        }
        if (properties2 == null) {
            properties2 = new Properties();
        }
        try {
            ClassLoader classLoader2;
            ClassLoader classLoader3 = Thread.currentThread().getContextClassLoader();
            if (classLoader3 != null) {
                if (PySystemState.initialize(properties, properties2, stringArray, classLoader, extensiblePyObjectAdapter, classLoader3)) {
                    return;
                }
            } else {
                Py.writeDebug("initializer", "Context class loader null, skipping");
            }
            if ((classLoader2 = PySystemState.class.getClassLoader()) != null) {
                if (PySystemState.initialize(properties, properties2, stringArray, classLoader, extensiblePyObjectAdapter, classLoader2)) {
                    return;
                }
            } else {
                Py.writeDebug("initializer", "PySystemState.class class loader null, skipping");
            }
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            Py.writeWarning("initializer", "Unable to load the UTF-8 charset to read an initializer definition");
            unsupportedCharsetException.printStackTrace(System.err);
        }
        catch (SecurityException securityException) {
        }
        catch (Exception exception) {
            Py.writeWarning("initializer", "Unexpected exception thrown while trying to use initializer service");
            exception.printStackTrace(System.err);
        }
        PySystemState.doInitialize(properties, properties2, stringArray, classLoader, extensiblePyObjectAdapter);
    }

    private static boolean initialize(Properties properties, Properties properties2, String[] stringArray, ClassLoader classLoader, ExtensiblePyObjectAdapter extensiblePyObjectAdapter, ClassLoader classLoader2) {
        Class<?> clazz;
        String string;
        InputStream inputStream = classLoader2.getResourceAsStream(INITIALIZER_SERVICE);
        if (inputStream == null) {
            Py.writeDebug("initializer", "'META-INF/services/org.python.core.JythonInitializer' not found on " + classLoader2);
            return false;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
        try {
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            Py.writeWarning("initializer", "Failed reading 'META-INF/services/org.python.core.JythonInitializer' from " + classLoader2);
            iOException.printStackTrace(System.err);
            return false;
        }
        try {
            clazz = classLoader2.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Py.writeWarning("initializer", "Specified initializer class '" + string + "' not found, continuing");
            return false;
        }
        try {
            ((JythonInitializer)clazz.newInstance()).initialize(properties, properties2, stringArray, classLoader, extensiblePyObjectAdapter);
        }
        catch (Exception exception) {
            Py.writeWarning("initializer", "Failed initializing with class '" + string + "', continuing");
            exception.printStackTrace(System.err);
            return false;
        }
        if (!initialized) {
            Py.writeWarning("initializer", "Initializer '" + string + "' failed to call doInitialize, using default initialization");
        }
        return initialized;
    }

    public static synchronized PySystemState doInitialize(Properties properties, Properties properties2, String[] stringArray, ClassLoader classLoader, ExtensiblePyObjectAdapter extensiblePyObjectAdapter) {
        if (initialized) {
            return Py.defaultSystemState;
        }
        initialized = true;
        Py.setAdapter(extensiblePyObjectAdapter);
        boolean bl = false;
        String string = PySystemState.getJarFileName();
        if (string != null) {
            bl = PySystemState.isStandalone(string);
        }
        PySystemState.initRegistry(properties, properties2, bl, string);
        PySystemState.initBuiltins(registry);
        PySystemState.initStaticFields();
        defaultPath = PySystemState.initPath(registry, bl, string);
        defaultArgv = PySystemState.initArgv(stringArray);
        defaultExecutable = PySystemState.initExecutable(registry);
        PySystemState.initPackages(registry);
        Py.defaultSystemState = new PySystemState();
        Py.setSystemState(Py.defaultSystemState);
        if (classLoader != null) {
            Py.defaultSystemState.setClassLoader(classLoader);
        }
        Py.initClassExceptions(PySystemState.getDefaultBuiltins());
        Py.defaultSystemState.initEncoding();
        new PySyntaxError("", 1, 1, "", "");
        return Py.defaultSystemState;
    }

    private static void initStaticFields() {
        String string;
        Py.None = new PyNone();
        Py.NotImplemented = new PyNotImplemented();
        Py.NoKeywords = new String[0];
        Py.EmptyObjects = new PyObject[0];
        Py.EmptyTuple = new PyTuple(Py.EmptyObjects);
        Py.EmptyFrozenSet = new PyFrozenSet();
        Py.NoConversion = new PySingleton("Error");
        Py.Ellipsis = new PyEllipsis();
        Py.Zero = new PyInteger(0);
        Py.One = new PyInteger(1);
        Py.False = new PyBoolean(false);
        Py.True = new PyBoolean(true);
        Py.EmptyString = new PyString("");
        Py.Newline = new PyString("\n");
        Py.Space = new PyString(" ");
        Py.stderr = new StderrWrapper();
        Py.stdout = new StdoutWrapper();
        if (Version.PY_RELEASE_LEVEL == 10) {
            string = "alpha";
        } else if (Version.PY_RELEASE_LEVEL == 11) {
            string = "beta";
        } else if (Version.PY_RELEASE_LEVEL == 12) {
            string = "candidate";
        } else if (Version.PY_RELEASE_LEVEL == 15) {
            string = "final";
        } else if (Version.PY_RELEASE_LEVEL == 170) {
            string = "snapshot";
        } else {
            throw new RuntimeException("Illegal value for PY_RELEASE_LEVEL: " + Version.PY_RELEASE_LEVEL);
        }
        version_info = new PyTuple(Py.newInteger(Version.PY_MAJOR_VERSION), Py.newInteger(Version.PY_MINOR_VERSION), Py.newInteger(Version.PY_MICRO_VERSION), Py.newString(string), Py.newInteger(Version.PY_RELEASE_SERIAL));
        subversion = new PyTuple(Py.newString("Jython"), Py.newString(Version.BRANCH), Py.newString(Version.SVN_REVISION));
    }

    public static boolean isPackageCacheEnabled() {
        return cachedir != null;
    }

    private static void initCacheDirectory(Properties properties) {
        String string = properties.getProperty(PYTHON_CACHEDIR_SKIP, "false");
        if (string.equalsIgnoreCase("true")) {
            cachedir = null;
            return;
        }
        cachedir = new File(properties.getProperty(PYTHON_CACHEDIR, CACHEDIR_DEFAULT_NAME));
        if (!cachedir.isAbsolute()) {
            cachedir = new File(prefix == null ? null : prefix.toString(), cachedir.getPath());
        }
    }

    private static void initPackages(Properties properties) {
        PySystemState.initCacheDirectory(properties);
        File file = cachedir != null ? new File(cachedir, "packages") : null;
        packageManager = new SysPackageManager(file, properties);
    }

    private static PyList initArgv(String[] stringArray) {
        PyList pyList = new PyList();
        if (stringArray != null) {
            for (String string : stringArray) {
                pyList.append(new PyString(string));
            }
        }
        return pyList;
    }

    private static PyObject initExecutable(Properties properties) {
        String string = properties.getProperty("python.executable");
        if (string == null) {
            return Py.None;
        }
        File file = new File(string);
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            file = file.getAbsoluteFile();
        }
        if (!file.isFile()) {
            return Py.None;
        }
        return new PyString(file.getPath());
    }

    private static void addBuiltin(String string) {
        String string2;
        String string3;
        int n = string.indexOf(58);
        if (n != -1) {
            string3 = string.substring(0, n).trim();
            string2 = string.substring(n + 1, string.length()).trim();
            if (string2.equals("null")) {
                string2 = null;
            }
        } else {
            string3 = string.trim();
            string2 = "org.python.modules." + string3;
        }
        if (string2 != null) {
            builtinNames.put(string3, string2);
        } else {
            builtinNames.remove(string3);
        }
    }

    private static void initBuiltins(Properties properties) {
        builtinNames = Generic.map();
        builtinNames.put("__builtin__", "");
        builtinNames.put("sys", "");
        for (String string : Setup.builtinModules) {
            PySystemState.addBuiltin(string);
        }
        String string = properties.getProperty("python.modules.builtin", "");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            PySystemState.addBuiltin(stringTokenizer.nextToken());
        }
        int n = builtinNames.size();
        PyObject[] pyObjectArray = new PyObject[n];
        int n2 = 0;
        for (String string2 : builtinNames.keySet()) {
            pyObjectArray[n2++] = Py.newString(string2);
        }
        builtin_module_names = new PyTuple(pyObjectArray);
    }

    public static String getBuiltin(String string) {
        return builtinNames.get(string);
    }

    private static PyList initPath(Properties properties, boolean bl, String string) {
        PyList pyList = new PyList();
        PySystemState.addPaths(pyList, properties.getProperty("python.path", ""));
        if (prefix != null) {
            String string2 = new File(prefix.toString(), "Lib").toString();
            pyList.append(new PyString(string2));
        }
        if (bl) {
            PySystemState.addPaths(pyList, string + "/Lib");
        }
        return pyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isStandalone(String string) {
        boolean bl = false;
        if (string != null) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(string);
                JarEntry jarEntry = jarFile.getJarEntry("Lib/os.py");
                bl = jarEntry != null;
            }
            catch (IOException iOException) {
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return bl;
    }

    private static String getJarFileName() {
        Class<PySystemState> clazz = PySystemState.class;
        String string = clazz.getName();
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        URL uRL = clazz.getResource(string2 + ".class");
        return PySystemState.getJarFileNameFromURL(uRL);
    }

    protected static String getJarFileNameFromURL(URL uRL) {
        String string = null;
        if (uRL != null) {
            try {
                String string2;
                int n;
                String string3 = "\\+";
                String string4 = "__ppluss__";
                String string5 = uRL.toString();
                string5 = string5.replaceAll("\\+", "__ppluss__");
                String string6 = URLDecoder.decode(string5, "UTF-8");
                string6 = string6.replaceAll("__ppluss__", "\\+");
                int n2 = string6.lastIndexOf(JAR_SEPARATOR);
                if (string6.startsWith(JAR_URL_PREFIX) && n2 > 0) {
                    string = string6.substring(JAR_URL_PREFIX.length(), n2);
                } else if (string6.startsWith(VFSZIP_PREFIX) && (n = string6.indexOf(".jar/".concat(string2 = PySystemState.class.getName().replace('.', '/')))) > 0) {
                    n += 4;
                    int n3 = VFSZIP_PREFIX.length();
                    if (Platform.IS_WINDOWS) {
                        ++n3;
                    }
                    string = string6.substring(n3, n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private static void addPaths(PyList pyList, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            pyList.append(new PyString(stringTokenizer.nextToken().trim()));
        }
    }

    public static PyJavaPackage add_package(String string) {
        return PySystemState.add_package(string, null);
    }

    public static PyJavaPackage add_package(String string, String string2) {
        return packageManager.makeJavaPackage(string, string2, null);
    }

    public static void add_classdir(String string) {
        packageManager.addDirectory(new File(string));
    }

    public static void add_extdir(String string) {
        packageManager.addJarDir(string, false);
    }

    public static void add_extdir(String string, boolean bl) {
        packageManager.addJarDir(string, bl);
    }

    static void displayhook(PyObject pyObject) {
        if (pyObject == Py.None) {
            return;
        }
        PyObject pyObject2 = Py.getSystemState().getBuiltins();
        pyObject2.__setitem__("_", Py.None);
        Py.stdout.println(pyObject.__repr__());
        pyObject2.__setitem__("_", pyObject);
    }

    static void excepthook(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        Py.displayException(pyObject, pyObject2, pyObject3, null);
    }

    public static void exit(PyObject pyObject) {
        throw new PyException(Py.SystemExit, pyObject);
    }

    public static void exit() {
        PySystemState.exit(Py.None);
    }

    public static PyTuple exc_info() {
        PyException pyException = Py.getThreadState().exception;
        if (pyException == null) {
            return new PyTuple(Py.None, Py.None, Py.None);
        }
        PyTraceback pyTraceback = pyException.traceback;
        PyObject pyObject = pyException.value;
        return new PyTuple(pyException.type, pyObject == null ? Py.None : pyObject, pyTraceback == null ? Py.None : pyTraceback);
    }

    public static void exc_clear() {
        Py.getThreadState().exception = null;
    }

    public static PyFrame _getframe() {
        return PySystemState._getframe(-1);
    }

    public static PyFrame _getframe(int n) {
        PyFrame pyFrame = Py.getFrame();
        while (n > 0 && pyFrame != null) {
            pyFrame = pyFrame.f_back;
            --n;
        }
        if (pyFrame == null) {
            throw Py.ValueError("call stack is not deep enough");
        }
        return pyFrame;
    }

    public void registerCloser(Callable<Void> callable) {
        this.closer.registerCloser(callable);
    }

    public boolean unregisterCloser(Callable<Void> callable) {
        return this.closer.unregisterCloser(callable);
    }

    public void cleanup() {
        this.closer.cleanup();
    }

    static {
        copyright = Py.newString("Copyright (c) 2000-2009 Jython Developers.\nAll rights reserved.\n\nCopyright (c) 2000 BeOpen.com.\nAll Rights Reserved.\n\nCopyright (c) 2000 The Apache Software Foundation.\nAll rights reserved.\n\nCopyright (c) 1995-2000 Corporation for National Research Initiatives.\nAll Rights Reserved.\n\nCopyright (c) 1991-1995 Stichting Mathematisch Centrum, Amsterdam.\nAll Rights Reserved.");
        builtin_module_names = null;
        exec_prefix = Py.EmptyString;
        byteorder = new PyString("big");
        initialized = false;
        warnoptions = new PyList();
        platform = new PyString("java");
        systemStateQueue = new ReferenceQueue();
        sysClosers = Generic.concurrentMap();
    }

    private static class DefaultBuiltinsHolder {
        static final PyObject builtins = DefaultBuiltinsHolder.fillin();

        private DefaultBuiltinsHolder() {
        }

        static PyObject fillin() {
            PyStringMap pyStringMap = new PyStringMap();
            __builtin__.fillWithBuiltins(pyStringMap);
            return pyStringMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PySystemStateCloser {
        private final Set<Callable<Void>> resourceClosers = new LinkedHashSet<Callable<Void>>();
        private volatile boolean isCleanup = false;
        private final Thread shutdownHook = this.initShutdownCloser();

        private PySystemStateCloser(PySystemState pySystemState) {
            WeakReference<PySystemState> weakReference = new WeakReference<PySystemState>(pySystemState, systemStateQueue);
            sysClosers.put(weakReference, this);
            PySystemStateCloser.cleanupOtherClosers();
        }

        private static void cleanupOtherClosers() {
            Reference reference;
            while ((reference = systemStateQueue.poll()) != null) {
                PySystemStateCloser pySystemStateCloser = (PySystemStateCloser)sysClosers.get(reference);
                pySystemStateCloser.cleanup();
            }
        }

        private synchronized void registerCloser(Callable<Void> callable) {
            if (!this.isCleanup) {
                this.resourceClosers.add(callable);
            }
        }

        private synchronized boolean unregisterCloser(Callable<Void> callable) {
            return this.resourceClosers.remove(callable);
        }

        private synchronized void cleanup() {
            if (this.isCleanup) {
                return;
            }
            this.isCleanup = true;
            if (this.shutdownHook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            for (Callable<Void> callable : this.resourceClosers) {
                try {
                    callable.call();
                }
                catch (Exception exception) {}
            }
            this.resourceClosers.clear();
        }

        private Thread initShutdownCloser() {
            try {
                ShutdownCloser shutdownCloser = new ShutdownCloser();
                Runtime.getRuntime().addShutdownHook(shutdownCloser);
                return shutdownCloser;
            }
            catch (SecurityException securityException) {
                Py.writeDebug("PySystemState", "Can't register cleanup closer hook");
                return null;
            }
        }

        private class ShutdownCloser
        extends Thread {
            private ShutdownCloser() {
                super("Jython Shutdown Closer");
            }

            public synchronized void run() {
                if (PySystemStateCloser.this.resourceClosers == null) {
                    return;
                }
                for (Callable callable : PySystemStateCloser.this.resourceClosers) {
                    try {
                        callable.call();
                    }
                    catch (Exception exception) {}
                }
                PySystemStateCloser.this.resourceClosers.clear();
            }
        }
    }
}

